%% PLOT_RESULTS generates Figure 1 from the paper.
%
% PLOT_RESULTS(FILENAME)
%
% To plot the results in the paper, use the file
% COMP_ITE10_N100_K4_C5_RESULTS.MAT as input.
%
% Input variables:
%   FILENAME        The filename of the *.mat file to plot the results from.
% 
% Code implemented by: Karsten Fyhn and Hamid Dadkhahi
% Contact e-mail: kfn@es.aau.dk
%
% Copyright 2012 Karsten Fyhn and Hamid Dadkhahi
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distribued on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
function plot_results(filename)
load(filename);

color_vector = ['b' 'r' 'c' 'g' 'm' 'k','y'];
m_vector = M;

% f_errors
figure(1); clf();
for j = 1:size(f_errors,1)
    plot(m_vector, mean(squeeze(f_errors(j,1,:,:)),2), color_vector(j),'LineWidth',2); hold on
end

l=legend('$\ell_1$-analysis','$\ell_1$-synthesis','SIHT','SDP','BOMP','CBP','BISP','Location','NE');
set(l,'Interpreter','latex');
xlabel('Number of measurements (m)');
ylabel('Normalized norm-2 error of f');
title(name, 'Interpreter', 'none');

% freq_errors
figure(2); clf();
for j = 1:size(freq_errors,1)
    semilogy(m_vector, mean(squeeze(freq_errors(j,1,:,:)),2), strcat(color_vector(j),'-o'),'LineWidth',2); hold on
end

% l=legend('$\ell_1$-analysis','$\ell_1$-synthesis','SIHT','SDP','BOMP','CBP','BISP','Location','NE');
% set(l,'Interpreter','latex');
xlabel('Number of measurements (M)');
ylabel('Average cost in frequency estimation');
% title(name, 'Interpreter', 'none');

% comp_times
figure(3); clf();
for j = 1:size(comp_times,1)
    semilogy(m_vector, mean(squeeze(comp_times(j,1,:,:)),2), color_vector(j),'LineWidth',2); hold on
end

l=legend('$\ell_1$-analysis','$\ell_1$-synthesis','SIHT','SDP','BOMP','CBP','BISP','Location','NE');
set(l,'Interpreter','latex');
xlabel('Number of measurements (m)');
ylabel('Average computation time');
title(name, 'Interpreter', 'none');

mean(mean(squeeze(comp_times),2),3)

end

