%% SIGNAL generates a signal based on a set of frequences.
%
% [SIG] = SIGNAL(KS, N)
%
% Input variables:
%   KS              The set of frequencies.
%   N               The length of the signal.
%
% Output variables:
%   SIG             The generated signal.
% 
% Code implemented by: Karsten Fyhn
% Contact e-mail: kfn@es.aau.dk
%
% Copyright 2012 Karsten Fyhn
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distribued on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
function [ sig ] = signal(ks, N)
    sig = zeros(N,1);
    ns = linspace(1, N, N)';
    for ii = 1:length(ks)
        sig = sig + exp(1j*2*pi*ks(ii)*ns/N)/sqrt(N);
    end
end

