%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% musicapprox.m
%
% Perform model-based approximation for off-Nyquist tone recovery to K
% nonzero coefficients using Root MUSIC.
% Assumes no two tones can have coherence larger than mu
%
% Inputs:
% xe - signal estimate input
% K - approximation sparsity
% windowsize - window size to use in Root MUSIC
%
% Outputs:
% tonesout - estimate component frequencies
% mu - frequency coefficients
%
% Written by Marco F. Duarte, Program in Applied and Computational Mathematics, Princeton Univeristy
% January 2010
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [xh,tonesout,mu] = musicapprox(xe,K,windowsize)

N = length(xe);

% Identify possible off-Nyquist frequencies
fhat = rootmusic(xe,K,max(windowsize,10*K)); % Dominant Frequencies via Root MUSIC
tonesout = fhat*N; % Normalize and recenter frequencies
idx = find(tonesout < 0);
tonesout(idx) = tonesout(idx)+N;
[xh,mu] = freqsignalest(xe,fhat); % Signal estimate and DTFT coefficients
