%% GEN_MATRIX_HUNGARIAN generates an input matrix for the Hungarian algorithm.
%
% [FREQ_MATRIX] = GEN_MATRIX_HUNGARIAN(TRUE_FREQS, ESTIMATED_FREQS)
%
% Generates the matrix used in the Hungarian algorithm to find the cost
% between the true and estimated frequencies.
%
% Input variables:
%   TRUE_FREQS      The true set of frequencies.
%   ESTIMATED_FREQS The estimated set of frequencies.

% Output variables:
%   FREQ_MATRIX     The input matrix for the Hungarian algorithm.
% 
% Code implemented by: Hamid Dadkhahi
% Contact e-mail: hdadkhahi@ecs.umass.edu
%
% Copyright 2012 Hamid Dadkhahi
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distribued on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
function freq_matrix = gen_matrix_hungarian(true_freqs,estimated_freqs)

N = length(true_freqs);
M = length(estimated_freqs);

freq_matrix = zeros(N,M);

for n = 1 : N
    for m = 1 : M
        freq_matrix(n,m) = abs(true_freqs(n) - estimated_freqs(m));
    end
end
