%% GEN_KS generates a set of frequences with a  given spacing.
%
% [KS] = GEN_KS(K, N, TONE_SEP)
%
% Generates K frequencies between (0,N) with minimum tone separation
% TONE_SEP.
%
% Input variables:
%   K               The number of frequencies to generate.
%   N               The maximum frequency to generate.
%   TONE_SEP        The minimum tone separation.
%
% Output variables:
%   KS              The set of K frequencies.
% 
% Code implemented by: Karsten Fyhn
% Contact e-mail: kfn@es.aau.dk
%
% Copyright 2012 Karsten Fyhn
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distribued on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
function [ ks ] = gen_ks(K, N, tone_sep)
    ks = zeros(K,1);
    for ii = 1:K
        tmp_k = (N-1)*rand(1);
        while sum(abs(ks - tmp_k) < tone_sep) > 0
            tmp_k = (N-1)*rand(1);
        end
        ks(ii) = tmp_k;
    end
end