%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% freqsignalest.m
%
% Approximate a signal using frequency-sparse model.
%
% Inputs:
% x - signal to approximate
% freqs - frequencies to use in approximation
%
% Outputs:
% xhat - signal approximation
% xc - frequency component coefficients
%
% Written by Marco F. Duarte, Program in Applied and Computational Mathematics, Princeton Univeristy
% January 2010
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [xhat,xc] = freqsignalest(x,freqs)
N = length(x);
Nidx = (0:N-1)';
% Calculate signal estimate given nonzero frequencies
xc = zeros(size(freqs));
xhat = zeros(N,1);
for ii=1:length(freqs),
    xc(ii) = x'*exp(-sqrt(-1)*2*pi*freqs(ii)*Nidx)/sqrt(N);
    xhat = xhat+xc(ii)*exp(sqrt(-1)*2*pi*freqs(ii)*Nidx)/sqrt(N);
end