%% COMP_NOISY_ITE10_N100_K4_C5 is a script to generate the results in Figure 2 in the paper.
%
% Code implemented by: Karsten Fyhn and Hamid Dadkhahi
% Contact e-mail: kfn@es.aau.dk
%
% Copyright 2012 Karsten Fyhn and Hamid Dadkhahi
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distribued on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
clear;
addpath('analysis_and_synthesis','cbp_bisp','siht','bomp','misc');
addpath(genpath('sdp'));

% Set random seed
seed = 0;
s = RandStream('mcg16807','Seed',seed);
RandStream.setGlobalStream(s);

num_iterations = 10;    % number of iterations
n = 100;                % length of the time-domain signal
k = 4;                  % sparsity level
M = 50;                 % vector of number of measurements
C = 5;                  % redundancy factor
SNR = linspace(0,20,5);
name = mfilename();

methods = 7;
f_errors = zeros(methods, length(C),length(M),num_iterations, length(SNR));
freq_errors = zeros(methods, length(C),length(M),num_iterations, length(SNR));
comp_times = zeros(methods, length(C),length(M),num_iterations, length(SNR));
for ii = 1:length(SNR)
    fprintf('SNR: %d\n', SNR(ii));
    [f_errors_ii, freq_errors_ii, comp_times_ii] = freq_estimation(n, k, M, C, num_iterations, SNR(ii));
    f_errors(:,:,:,:,ii) = f_errors_ii;
    freq_errors(:,:,:,:,ii) = freq_errors_ii;
    comp_times(:,:,:,:,ii) = comp_times_ii;
end

string = strcat(mfilename(),'_RESULTS.mat');
save(string);
