%% SYNTHESIS_EQ implements the $\ell_1$-synthesis algorithm without noise.
%
% [X_HAT] = SYNTHESIS_EQ(Y, A, D)
%
% This function implements the $\ell_1$-synthesis algorithm from [1].
%
% Input variables:
%   Y               The measurements.
%   A               The measurement matrix.
%   D               The dictionary matrix.
%
% Output variables:
%   X_HAT           The reconstructed coefficients for the dictionary matrix.
% 
% References:
%   [1] E. J. Candes, Y. C. Eldar, D. Needell, and P. Randall, ?Compressed
%       sensing with coherent and redundant dictionaries?, Applied and
%       Computational Harmonic Analysis, vol. 31, no. 1, pp. 59 ? 73, 2011.
%
% Code implemented by: Hamid Dadkhahi
% Contact e-mail: hdadkhahi@ecs.umass.edu
%
% Copyright 2012 Hamid Dadkhahi
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%   http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distribued on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
function x_hat = synthesis_eq(y,A,D)

n = size(D,1);
m = size(A,1);
p = size(D,2);
c = p / n;

% Synthesis
cvx_quiet(1);
cvx_precision best;
%cvx_precision high;
cvx_begin
    variable x_hat(p) complex;
    minimize( norm(x_hat,1) );
    subject to 
        %norm(A*D*x_hat - y,2) <= epsilon*norm(y,2);
        y == A*D*x_hat;
cvx_end