/*
    PacketBench - Workload Characterization Tool
    Copyright (C) 2004  Ramaswamy Ramaswamy

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/* 
 * USE BSD STYLE HEADERS FOR NOW 
*/

#define _BSD_SOURCE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pcap.h> 
#include <errno.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#define GLOBAL_PACKET_MEMORY

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef DROP
#define DROP 0
#endif

#ifndef DUMP
#define DUMP 1
#endif

#ifndef BENCHMARK_FUNCTION
#define BENCHMARK_FUNCTION
#endif

/*
 * Number of time units to increment
 * packet time stamp by
 */
#ifndef INCTIMEUNITS
#define INCTIMEUNITS 1
#endif

/* 
 * Size of packet queue (number of packets)
 */
#ifndef PACKET_QUEUE_SIZE
#define PACKET_QUEUE_SIZE 64
#endif

/* 
 * Size of data structure (bytes) used to store packets (see below)
 */
#ifndef PACKET_SIZE
#define PACKET_SIZE 2048
#endif

// Trace file format index, 0=TCPDUMP, 1=TSH
int trace_format;

/*
 * Size in bytes of a Time Sequence Header file (NLANR)
 */
#define TSH_RECORD_SIZE 44

struct meta
{
  int ll_length; /* Packet length as returned by link layer */
  unsigned short ll_type; /* Packet type as returned by link layer */
  double time; // Timestamp (seconds.microseconds)
  struct packet *next;
};

struct packet
{
  /* stores packet data */
  unsigned char data[PACKET_SIZE-sizeof(struct meta)]; 
  /* stores control information for packet */
  struct meta meta_buffer;
};

typedef struct packet packet;

void write_packet_to_tcpdump_file(packet *,int);
void write_packet_to_tsh_file(int);





