/*
    PacketBench - Workload Characterization Tool
    Copyright (C) 2004  Ramaswamy Ramaswamy

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "bench.h"
#include "packet_process.h"

int printip(packet *pass_packet)
{  
  struct ip *iphdr;
  char *daddr;

  /*
   * Extract the IP header from the packet
   */
  iphdr = (struct ip*)(pass_packet->data);

#ifdef VERBOSE
  daddr = inet_ntoa(iphdr->ip_dst);
  printf("\nType : 0x%x",pass_packet->meta_buffer.ll_type);
  printf("\nLength : %d",pass_packet->meta_buffer.ll_length);
  printf("\nDestination Address : %s",daddr);
#endif     

  /*
   * Dump the packet back to trace file
   */
  
  switch(trace_format)
    {
    case 0 : 
      write_packet_to_tcpdump_file(pass_packet,DUMP);
      break;
    case 1 :
      write_packet_to_tsh_file(DUMP);
      break;
    }      

  /*
   * Function will return 0 if it needs to store the packet in queue
   * Queue pointers are modified based on return value  
   */

  return 1;
}

