/*
    PacketBench - Workload Characterization Tool
    Copyright (C) 2004  Ramaswamy Ramaswamy

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#define	IPFLOW_HASHBITS 20 /* should not be a multiple of 8 */
#define	IPFLOW_HASHSIZE	(1 << IPFLOW_HASHBITS)

// Remember to change in bench.h
//#undef GLOBAL_PACKET_MEMORY
#define GLOBAL_PACKET_MEMORY

// Protocol numbers
#define TCP_P 6
#define UDP_P 17

// TCP flags
#define TH_FIN        0x01
#define TH_SYN        0x02
#define TH_RST        0x04
#define TH_PUSH       0x08
#define TH_ACK        0x10
#define TH_URG        0x20

// Timeout value in seconds for flows
#define TIMEOUT 30

static int IP_SIZE = sizeof(struct ip);
static int TCP_SIZE = sizeof(struct tcphdr);

// stored in hash table. this is a hashentry
// this would be stored in SRAM
struct fivetuple
{
  struct in_addr dst;
  struct in_addr src;
  unsigned short sport;
  unsigned short dport;
  unsigned char ip_p;
  struct flow_record *flow;
  struct fivetuple *next;
};

struct tcp_stats
{
  unsigned int th_firstseq;     // TCP seq (initial packet)
  unsigned int th_firstack;     // TCP ack (initial packet)
  unsigned char th_firstflags;   // TCP flags (initial packet)
  unsigned int th_lastseq;       // TCP seq (last packet)
  unsigned int th_lastack;       // TCP ack (last packet)
  unsigned char th_lastflags;     // TCP flags (last packet)
};

struct udp_stats
{
  unsigned int byte_count;
};

// flow info. this should be stored in DRAM
struct flow_record
{
  unsigned int packet_count; // packet count for flow
  unsigned char ip_tos;      // IP type of service
  unsigned char ip_off;      // IP frag offset
  union
  {
    struct tcp_stats tcp_stats;
    struct udp_stats udp_stats;
  } stats;
  double first_time; // Time first packet in flow was seen
  double last_time; // Time last packet in flow was seen
  unsigned short status;     // Flow status, TRUE=active
  unsigned int packet_count_term; // packet count after flow termination
  struct flow_record *next;
};

struct hash_entry
{
  struct fivetuple *fivetuple;
};

#ifdef GLOBAL_PACKET_MEMORY
struct hash_entry temp_hash_table[IPFLOW_HASHSIZE];
struct flow_record temp_free_flow_list[IPFLOW_HASHSIZE];
struct fivetuple temp_free_fivetuple_list[IPFLOW_HASHSIZE];
#endif

// global pointers for hash table, and free lists
struct hash_entry *hash_table;
struct flow_record *free_flow_list;
struct fivetuple *free_fivetuple_list;

// function called by process_packet()
int flowid(packet *);

// init function
void init_flowid();
void print_flow();

