#include <stdio.h>
#include <stdlib.h>
#include "frag.h"

extern char *optarg;

int fragsize = 128;

struct ip ip[IPBUF];
struct ip frag[FRAGBUF];

#define ADDCARRY(x)  (x > 65535 ? x -= 65535 : x)
#define REDUCE {l_util.l = sum; sum = l_util.s[0] + l_util.s[1]; ADDCARRY(sum);}

int in_cksum(register char *buf, register int len) {
  long sum = 0;

  while (len > 1) {
    sum += *((unsigned short *) buf)++;
    if (sum & 0x80000000)
      sum = (sum & 0xFFFF) + (sum >> 16);
    len -= 2;
  }

  if (len)
    sum += (unsigned short) *buf;

  while (sum >> 16)
    sum = (sum & 0xFFFF) + (sum >> 16);

  return ~sum;
}


print_ip(struct ip *ip) {
  printf("id=%04x len=%d off=%d chksum=%04x\n", ip->ip_id, ip->ip_len, ip->ip_off*8, ip->ip_sum);
}

int fragment(struct ip *ip) {
  int l;
  int f=0;

  l = ip->ip_len;
  while (l > fragsize) {
    memcpy(&(frag[f]), ip, sizeof(struct ip));
    frag[f].ip_len = fragsize;
    frag[f].ip_off = (f*fragsize) >> 3;
    frag[f].ip_sum = 0;
    frag[f].ip_sum = in_cksum((char *)&(frag[f]), 20);
    f++;
    l-=fragsize;
  }
  memcpy(&(frag[f]), ip, sizeof(struct ip));
  frag[f].ip_len = l;
  frag[f].ip_off = (f*fragsize) >> 3;
  frag[f].ip_sum = 0;
  frag[f].ip_sum = in_cksum((char *)&(frag[f]), 20);
  f++;

  return f;
}

int main(int argc, char *argv[]) {
  int i, packets, f, j;

  while((i = getopt(argc,argv,"f:")) != EOF) {
    switch(i) {
    case 'f':
      fragsize = atoi(optarg);
      break;
    default:
      printf("usage: %s -f fragsize\n", argv[0]);
      exit(1);
    }
  }
  if (fragsize != (fragsize & 0xfffffff8)) {
    printf("fragsize must be multiple of 8!\n");
    exit(-1);
  }

  while ((packets = fread(ip, sizeof(struct ip), IPBUF, stdin)) > 0) {
    for (i=0; i<packets; i++) {

      // print_ip(&(ip[i]));

      f = fragment(&(ip[i]));
      //      for (j=0; j<f; j++) {
      //	print_ip(&(frag[j]));
      //	printf("back-check = %04x\n", in_cksum((char *)&(frag[j]), sizeof(struct ip))&0xffff);
      //      }
    }
  }

  return 0;
}



