#include <stdio.h>
#include <stdlib.h>
#include "frag.h"

extern char *optarg;

int main(int argc, char *argv[]) {
  int i;
  int packets = 1;
  int sizemin = 1500;
  int sizemax = 1500;
  struct ip ip;
  int id;

  while((i = getopt(argc,argv,"p:s:S:")) != EOF) {
    switch(i) {
    case 'p':
      packets = atoi(optarg);
      break;
    case 's':
      sizemin = atoi(optarg);
      break;
    case 'S':
      sizemax = atoi(optarg);
      break;
    default:
      printf("usage: %s -p packets -s sizemin -S sizemax\n", argv[0]);
      exit(1);
    }
  }

  ip.ip_v_hl = 0x45;
  ip.ip_tos = 0x10;
  ip.ip_id = id++ & 0xffff;
  ip.ip_off = IP_OFFMASK & 0;
  ip.ip_ttl = 255;
  ip.ip_p = random() & 0xff;
  ip.ip_sum = 0;
  ip.ip_src = random() & 0xffffffff;
  ip.ip_dst = random() & 0xffffffff;
  ip.ip_len = sizemin + (random() % (sizemax-sizemax+1));

  for (i=0; i<packets; i++) {
    fwrite(&ip, sizeof(struct ip), 1, stdout);
    ip.ip_id = id++ & 0xffff;
    ip.ip_p = random() & 0xff;
    ip.ip_src = random() & 0xffffffff;
    ip.ip_dst = random() & 0xffffffff;
    ip.ip_len = sizemin + (random() % (sizemax-sizemax+1));
  }
  return(0);
}




