#include <stdio.h>
#include <stdlib.h>
#include "drr.h"

extern char *optarg;

struct q_head q[NO_OF_QUEUES];

struct queue el[NO_OF_ELEMS];

int elemleft;

int quantum = 50;

fill_next_request() {
  int i;
  int buf[2*NO_OF_ELEMS];

  bzero(q, NO_OF_QUEUES * sizeof(struct q_head));
  bzero(el, NO_OF_ELEMS * sizeof(struct queue));
  for (i=0; i<NO_OF_QUEUES; i++) {
    q[i].tail = &(q[i].queue);
    q[i].next_q = &(q[(i+1)%NO_OF_QUEUES]);
  }

  elemleft = fread(buf, 8, NO_OF_ELEMS, stdin);

  // printf("read %d records\n", elemleft);

  if (elemleft == 0) exit(0);

  for (i=0; i<elemleft; i++) {
    // printf("processing q=%d size=%d\n", buf[2*i], buf[2*i+1]);
    el[i].size = buf[2*i+1];
    *(q[buf[2*i]-1].tail) = &(el[i]);
    q[buf[2*i]-1].tail = &(el[i].next);
  }
}

print_q() {
  int i;
  struct queue *j;

  for (i=0; i<NO_OF_QUEUES; i++) {
    printf("queue %03d: ", i);
    j = q[i].queue;
    while (j) {
      printf("%d ", j->size);
      j = j->next;
    }
    printf(".\n");
  }
}

void schedule() {
  int i;
  struct q_head *p;

  p = q;

  while (elemleft > 0) {
    while (p->next_q->queue == 0) {
      p->next_q = p->next_q->next_q;
      // printf("deleting queue\n");
    }
    p = p->next_q;
    p->deficit += quantum;
    while (p->queue && (p->deficit >= p->queue->size)) {
      // printf("sending %d\n", p->queue->size);
      p->deficit -= p->queue->size;
      p->queue = p->queue->next;
      elemleft--;
    }
    // printf("next queue\n");
  }
}

int main(int argc, char *argv[]) {
  int i;

  while((i = getopt(argc,argv,"q:")) != EOF) {
    switch(i) {
    case 'q':
      quantum = atoi(optarg);
      break;
    default:
      printf("usage: %s -q quantum\n", argv[0]);
      exit(1);
    }
  }

  while (1) {
    fill_next_request();
    schedule();
  }
  //print_q();
}







