/* decryption of I/O stream with CAST-128 algorithm based on SSLeay library */

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include "cast.h"

unsigned char k[16]={
        0x01,0x23,0x45,0x67,0x12,0x34,0x56,0x78,
        0x23,0x45,0x67,0x89,0x34,0x56,0x78,0x9A
        };

#define CFB_TEST_SIZE 24

#define BLOCK 8

int main() {
  CAST_KEY key;
  char iv[8]; 
  char coded[BLOCK+1];
  char decoded[BLOCK+1];
  int n;
  
  CAST_set_key(&key, 128, k);
  
  bzero(coded, sizeof(coded));
  bzero(decoded, sizeof(decoded));

  memcpy(iv, k, 8);

  while (!feof(stdin)) {
    
    if (fread(coded, 1, BLOCK, stdin) != BLOCK) {
      return 0;
    }
    n=1;
    CAST_ofb64_encrypt(coded, decoded, BLOCK, &key, iv, &n);
    fwrite(decoded, BLOCK, 1, stdout);
  }

  return 0;
}
